﻿Imports System.IO

Public Class Form1

    'dieses kleine Projekt soll ein kleines Beispiel
    'für Suchen und Ersetzen von Text in einer RichTextBox mit kleiner Navigationshilfe sein

    '*******************************************************************************************
    'dieser Source-Code wurde erstellt mit der "Visual Basic 2010 Express Edition"
    '(getestet mit dem Betriebssystem: WinXP Sp3, teilweise unter Vista, Windows7 und Windows8)
    'dieses Projekt darf frei verwendet und den eigenen Ansprüchen entsprechend geändert werden!

    'Für evtl. auftretende Schäden jeglicher Art wird nicht gehaftet!!!
    '*******************************************************************************************

    Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As IntPtr, ByVal wMsg As Integer, _
                                                                            ByVal wParam As Integer, ByRef lParam As Integer) As Integer
    Private Const EM_LINEFROMCHAR As Int32 = &HC9

    Private Const sOpenFilter As String = "RTF-Datei *.rtf|*.rtf|Text-Datei *.txt|*.txt|Alle Dateien *.*|*.*"

#Region "Controls von TabTools ausrichten"
    Private Sub InitResizeControlsTabControl()
        Try
            'das ist fast wie zu VB-6 Zeiten (eigentlich müsste man sich darum nicht mehr kümmern)
            'Ausrichtung der Controls im FormLoad-Ereignis von MDIHTMLPad in (den Problem-Tabs) ToolTabTools
            'ab jetzt dürfte, was die Ausrichtung und Sichtbarkeit von Controls angeht, es keine Ärgernisse mehr geben!
            With Me
                'Suchergebnisse
                .ListViewFindResults.Top = .ToolStripSearchData.Height + 5
                .ListViewFindResults.Left = 5
                .ListViewFindResults.Width = CInt(.TabPageFindResults.Width - 10)
                .ListViewFindResults.Height = CInt(.TabPageFindResults.Height - .ToolStripSearchData.Height - 10)
                'Ersetzen
                .ListViewReplaceResults.Top = .ToolStripReplaceData.Height + 5
                .ListViewReplaceResults.Left = 5
                .ListViewReplaceResults.Width = CInt(.TabPageReplaceResults.Width - 10)
                .ListViewReplaceResults.Height = CInt(.TabPageReplaceResults.Height - .ToolStripReplaceData.Height - 10)
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in initResizeControlsTabTools")
        End Try
    End Sub
#End Region

    Private Sub Form1_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Call InitResizeControlsTabControl()
    End Sub

    Private Sub ÖffnenToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ÖffnenToolStripMenuItem.Click
        Try
            Dim myOpenFileDialog As New OpenFileDialog
            With myOpenFileDialog
                With myOpenFileDialog
                    .Filter = sOpenFilter
                    If .ShowDialog = Windows.Forms.DialogResult.OK Then
                        Dim sFileName As String = .FileName
                        If CBool(InStr(sFileName, ".")) = True Then
                            Dim sExtension As String = Mid(sFileName, InStrRev(sFileName, ".") + 1)
                            Select Case StrConv(sExtension, VbStrConv.Lowercase)
                                Case "rtf"
                                    Me.RichTextBox1.LoadFile(sFileName, RichTextBoxStreamType.RichText)
                                Case "txt"
                                    Me.RichTextBox1.LoadFile(sFileName, RichTextBoxStreamType.PlainText)
                                Case Else
                                    Me.RichTextBox1.Text = File.ReadAllText(sFileName, System.Text.Encoding.Default)
                            End Select
                        Else
                            Me.RichTextBox1.Text = File.ReadAllText(sFileName, System.Text.Encoding.Default)
                        End If
                    End If
                    .Dispose()
                End With
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical, "Fehler")
        End Try
    End Sub

    Private Sub ClsSliderLabel1_Click(sender As Object, e As System.EventArgs) Handles ClsSliderLabel1.Click
        Try
            With Me
                .ClsSliderLabel1.Pressed = Not .ClsSliderLabel1.Pressed
                .TabControlTools2.Visible = .ClsSliderLabel1.Pressed
                Dim iFinds As Integer = .ListViewFindResults.Items.Count
                Dim iReplaceFinds As Integer = .ListViewReplaceResults.Items.Count
                With .ClsSliderLabel1
                    Select Case Me.TabControlTools2.SelectedIndex
                        Case 0 'Suchergebnisse

                            If iFinds > 0 Then
                                .ForeColor = Color.Blue
                                'den Suchtext ermitteln
                                Dim sSearchText As String = Me.ListViewFindResults.Items.Item(0).Text
                                sSearchText = Strings.Left(sSearchText, InStr(sSearchText, " ") - 1)
                                If .Pressed = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden, Suchergebnisse anzeigen"
                                Else
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden"
                                End If
                            Else
                                .ForeColor = Color.Red
                                .Text = String.Empty
                            End If

                        Case 1 'Ersetzenergebnisse
                            If iReplaceFinds > 0 Then
                                .ForeColor = Color.Blue
                                'den Suchtext ermitteln
                                Dim sSearchText As String = Me.ListViewReplaceResults.Items.Item(0).Text
                                sSearchText = Strings.Left(sSearchText, InStr(sSearchText, " ") - 1)
                                'den Suchtext ermitteln
                                Dim sReplaceText As String = Me.ListViewReplaceResults.Items(0).SubItems(3).Text
                                If .Pressed = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iReplaceFinds & " mal gefunden und durch " & vbQuote & sReplaceText & vbQuote & " ersetzt, Ergebnisse anzeigen"
                                Else
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iReplaceFinds & " mal gefunden und durch" & vbQuote & sReplaceText & vbQuote & " ersetzt"
                                End If
                            Else
                                .ForeColor = Color.Red
                                .Text = String.Empty
                            End If

                    End Select
                End With
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in ClsSliderLabel1_Click")
        End Try
    End Sub

#Region "Suchen"
    Private Sub btnSearch_Click(sender As System.Object, e As System.EventArgs) Handles btnSearch.Click
        Try
            With Me
                If CBool(String.IsNullOrWhiteSpace(.RichTextBox1.Text)) = False Then
                    Dim sSearchString As String = Me.txtSearch.Text
                    'prüfen ob ein verwertbarer Such-String eingegeben wurde
                    If String.IsNullOrWhiteSpace(sSearchString) = False Then
                        Me.TabControlTools2.SelectedTab = Me.TabPageFindResults
                        With Me.ListViewFindResults
                            If .Items.Count > 0 Then
                                Dim sFindText As String = .Items.Item(0).Text
                                sFindText = Strings.Left(sFindText, InStr(sFindText, " gefunden in ...") - 1)
                                If StrConv(sSearchString, VbStrConv.Lowercase) = StrConv(sFindText, VbStrConv.Lowercase) Then
                                    .Items.Clear()
                                End If
                            End If
                        End With

                        'das Ergebnis der Suche in ListViewFindResults einfügen
                        Call InsertFindStringInListView(.RichTextBox1, .RichTextBox1.Text, sSearchString, .ListViewFindResults)
                        'angegebenen Text suchen (beginnend ab aktueller Position)
                        Call SelectText(sSearchString, False, False, , btnSearchBackword.Checked)
                    End If
                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical, "Fehler")
        End Try
    End Sub

#Region "ListViewFindResults"

#Region "Navigation FindResults"

    Private Sub UpDateSearchNavigationControls(ByVal ItemIndex As Integer, ByVal bLVTopItem As Boolean)
        Try
            With Me
                If .ListViewFindResults.Items.Count > 0 Then
                    If ItemIndex > -1 Then
                        If bLVTopItem = True Then
                            .ListViewFindResults.TopItem = .ListViewFindResults.Items.Item(ItemIndex)
                        End If
                        Dim bIndexEnabled As Boolean = CBool(ItemIndex >= 0)
                        If CBool(ItemIndex = 0) = True Then
                            .btnGoToFirstSearchItem.Enabled = False
                            .btnGoToPreviousSearchItem.Enabled = False
                        Else
                            .btnGoToFirstSearchItem.Enabled = bIndexEnabled
                            .btnGoToPreviousSearchItem.Enabled = bIndexEnabled
                        End If
                        .lblCountSearchItem.Text = ItemIndex + 1 & " von " & .ListViewFindResults.Items.Count
                        .lblCountSearchItem.ForeColor = Color.Blue
                        .btnGoToNextSearchItem.Enabled = (ItemIndex < .ListViewFindResults.Items.Count - 1)
                        .btnGoToLastSearchItem.Enabled = (ItemIndex < .ListViewFindResults.Items.Count - 1)
                        'den Suchtext ermitteln
                        Dim sSearchText As String = .ListViewFindResults.Items.Item(ItemIndex).Text
                        sSearchText = StrConv(Strings.Left(sSearchText, InStr(sSearchText, " gefunden in ...") - 1), VbStrConv.Lowercase)
                        Dim iStart As Integer = CInt(.ListViewFindResults.Items(ItemIndex).SubItems(2).Text)
                        With Me.RichTextBox1
                            Dim lpSource As String = StrConv(.Text, VbStrConv.Lowercase)
                            If Len(lpSource) >= Len(sSearchText) Then
                                Dim sRevFindText As String = Mid(lpSource, iStart + 1, Len(sSearchText))
                                If CBool(StrConv(sRevFindText, VbStrConv.Lowercase) = StrConv(sSearchText, VbStrConv.Lowercase)) = True Then
                                    .Select(iStart, Len(sSearchText))
                                    .Focus()
                                End If
                            End If
                        End With

                    Else
                        .btnGoToFirstSearchItem.Enabled = False
                        .btnGoToPreviousSearchItem.Enabled = False
                        .lblCountSearchItem.Text = "0 von " & .ListViewFindResults.Items.Count
                        .lblCountSearchItem.ForeColor = Color.Blue
                        .btnGoToNextSearchItem.Enabled = False
                        .btnGoToLastSearchItem.Enabled = False
                    End If
                Else
                    .btnGoToFirstSearchItem.Enabled = False
                    .btnGoToPreviousSearchItem.Enabled = False
                    .lblCountSearchItem.Text = "0 von 0"
                    .lblCountSearchItem.ForeColor = Color.Red
                    .btnGoToNextSearchItem.Enabled = False
                    .btnGoToLastSearchItem.Enabled = False
                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in UpDateSearchNavigationControls")
        End Try
    End Sub

    Private Sub btnGoToFirstSearchItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToFirstSearchItem.Click
        Try

            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    .Items.Item(0).Selected = True
                    Call UpDateSearchNavigationControls(0, True)
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToPreviousSearchItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToPreviousSearchItem.Click
        Try

            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    If .Items.Item(0).Selected = True Then
                        Exit Sub
                    Else
                        Dim PrevItem As Integer = 0
                        'Call Freeze()
                        For i As Integer = 0 To .Items.Count - 1
                            If CBool(.Items.Item(i).Selected) = True Then
                                PrevItem = i - 1
                                Exit For
                            End If
                        Next
                        'Call Defrost()
                        .Items.Item(PrevItem).Selected = True
                        Call UpDateSearchNavigationControls(PrevItem, True)
                    End If
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToNextSearchItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToNextSearchItem.Click
        Try

            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    If .Items.Item(.Items.Count - 1).Selected = True Then
                        Exit Sub
                    Else
                        Dim NextItem As Integer = 0
                        'Call Freeze()
                        For i As Integer = 0 To .Items.Count - 1
                            If CBool(.Items.Item(i).Selected) = True Then
                                NextItem = i + 1
                                Exit For
                            End If
                        Next
                        'Call Defrost()
                        .Items.Item(NextItem).Selected = True
                        Call UpDateSearchNavigationControls(NextItem, True)
                    End If
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToLastSearchItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToLastSearchItem.Click
        Try

            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    .Items.Item(.Items.Count - 1).Selected = True
                    Call UpDateSearchNavigationControls(.Items.Count - 1, True)
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnRefreshFindResults_Click(sender As System.Object, e As System.EventArgs) Handles btnRefreshFindResults.Click
        Try

            If CBool(String.IsNullOrWhiteSpace(Me.RichTextBox1.Text)) = False Then
                With Me
                    If .ListViewFindResults.Items.Count > 0 Then
                        'den Suchtext ermitteln
                        Dim sSearchText As String = .ListViewFindResults.Items.Item(0).Text
                        sSearchText = StrConv(Strings.Left(sSearchText, InStr(sSearchText, " gefunden in ...") - 1), VbStrConv.Lowercase)
                        .ListViewFindResults.Items.Clear()
                        'das Ergebnis der Suche in ListViewFindResults einfügen
                        Call InsertFindStringInListView(.RichTextBox1, .RichTextBox1.Text, sSearchText, Me.ListViewFindResults)
                        'angegebenen Text suchen (beginnend ab aktueller Position)
                        Call SelectText(sSearchText, False, False, , btnSearchBackword.Checked)
                    End If
                End With
            End If

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnClearFindResults_Click(sender As System.Object, e As System.EventArgs) Handles btnClearFindResults.Click
        Try
            With Me
                .ListViewFindResults.Items.Clear()
                .btnGoToFirstSearchItem.Enabled = False
                .btnGoToPreviousReplaceItem.Enabled = False
                .lblCountSearchItem.Text = "{0} von {0}"
                .btnGoToNextSearchItem.Enabled = False
                .btnGoToLastSearchItem.Enabled = False
                .ClsSliderLabel1.Text = String.Empty
            End With
        Catch ex As Exception

        End Try
    End Sub
#End Region

    Private Sub SelectFindString()
        Try
            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    For i As Integer = 0 To .Items.Count - 1
                        If .Items.Item(i).Selected = True Then
                            'den Suchtext ermitteln
                            Dim sSearchText As String = .Items.Item(i).Text
                            sSearchText = Strings.Left(sSearchText, InStr(sSearchText, " gefunden in ...") - 1)
                            'die Position einlesen
                            Dim iPos As Integer = .Items(i).SubItems(2).Text
                            With Me.RichTextBox1
                                'entsprechend markiert anzeigen
                                .Select(iPos, Len(sSearchText))
                                .Focus()
                            End With
                            Exit For
                        End If
                    Next
                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in SelectFindString")
        End Try
    End Sub

    Private Sub ListViewFindResults_DoubleClick(sender As Object, e As System.EventArgs) Handles ListViewFindResults.DoubleClick
        Call SelectFindString()
    End Sub

    Private Sub ListViewFindResults_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles ListViewFindResults.KeyDown
        Try
            If e.KeyCode = Keys.Return Then
                Call SelectFindString()
            End If
        Catch ex As Exception

        End Try
    End Sub

    Private Sub ListViewFindResults_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles ListViewFindResults.SelectedIndexChanged
        Try

            With Me.ListViewFindResults
                If .Items.Count > 0 Then
                    Dim SelectedItem As Integer = -1
                    'Call Freeze()
                    For i As Integer = 0 To .Items.Count - 1
                        If CBool(.Items.Item(i).Selected) = True Then
                            SelectedItem = i
                            Exit For
                        End If
                    Next
                    'Call Defrost()
                    Call UpDateSearchNavigationControls(SelectedItem, False)
                End If
            End With

        Catch ex As Exception
            Call Defrost()
        End Try
    End Sub

#End Region

#End Region

#Region "Ersetzen"
    Private Sub btnReplace_Click(sender As System.Object, e As System.EventArgs) Handles btnReplace.Click
        Try
            With Me.RichTextBox1
                If String.IsNullOrWhiteSpace(Me.txtSearch.Text) = False And String.IsNullOrWhiteSpace(Me.txtReplace.Text) = False Then
                    Dim sSearchText As String = Me.txtSearch.Text
                    Dim sReplaceText As String = Me.txtReplace.Text
                    If CBool(.SelectedText = String.Empty) = True Then
                        If CBool(InStr(.Text, sSearchText)) = True Then
                            'angegebenen Text suchen (beginnend ab aktueller Position)
                            Call SelectText(sSearchText, False, False, , btnSearchBackword.Checked)
                        End If
                    End If
                    If String.IsNullOrWhiteSpace(.SelectedText) = False Then
                        Me.TabControlTools2.SelectedTab = Me.TabPageReplaceResults
                        Dim sSelText As String = .SelectedText
                        Dim iStart = CInt(.SelectionStart)
                        Dim iWordFind As Integer = 1
                        Dim iWordEndTag As Integer = 0

                        .SelectedText = sReplaceText

                        'Zeilen-Index ermitteln:
                        Dim iLineIndex As Integer = SendMessage(.Handle, EM_LINEFROMCHAR, _
                              iStart, 0&)
                        'den markierten Text mit dem Such-Text vergleichen
                        If CBool(sSelText = sSearchText) = True Then
                            'entsprechend einfügen
                            With Me.ListViewReplaceResults
                                .Items.Add(sSearchText & " gefunden in ...")
                                .Items(.Items.Count - 1).SubItems.Add(iLineIndex + 1)
                                .Items(.Items.Count - 1).SubItems.Add(iStart)
                                .Items(.Items.Count - 1).SubItems.Add(sReplaceText)
                                .Items(.Items.Count - 1).ImageIndex = 1
                            End With
                        Else
                            'entsprechend einfügen
                            With Me.ListViewReplaceResults
                                .Items.Add(sSelText & " gefunden in ...")
                                .Items(.Items.Count - 1).SubItems.Add(iLineIndex + 1)
                                .Items(.Items.Count - 1).SubItems.Add(iStart)
                                .Items(.Items.Count - 1).SubItems.Add(sReplaceText)
                                .Items(.Items.Count - 1).ImageIndex = 1
                            End With
                        End If

                    End If 'Ende von If String.IsNullOrWhiteSpace(.SelectedText) = False Then

                    Dim iFinds As Integer = Me.ListViewReplaceResults.Items.Count
                    With Me.ClsSliderLabel1
                        If Me.TabControlTools2.SelectedIndex = 1 Then
                            If iFinds > 0 Then
                                .ForeColor = Color.Blue
                                If .Pressed = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden und durch " & vbQuote & sReplaceText & vbQuote & " ersetzt, Ergebnisse anzeigen"
                                Else
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden und durch" & vbQuote & sReplaceText & vbQuote & " ersetzt"
                                End If
                            Else
                                .ForeColor = Color.Red
                                If String.IsNullOrWhiteSpace(sSearchText) = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde nicht gefunden"
                                Else
                                    .Text = String.Empty
                                End If
                            End If
                        End If
                    End With
                Else

                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical, "Fehler")
        End Try
    End Sub

    Private Sub btnReplaceAll_Click(sender As System.Object, e As System.EventArgs) Handles btnReplaceAll.Click
        Try
            With Me
                .TabControlTools2.SelectedTab = .TabPageReplaceResults
                Call InsertReplaceTextInListView(.RichTextBox1, .txtSearch.Text, .txtReplace.Text, .ListViewReplaceResults)
            End With
        Catch ex As Exception

        End Try
    End Sub

#Region "ListViewReplaceResults"

#Region "Navigation ReplaceResults"
    Private Sub UpDateReplaceNavigationControls(ByVal ItemIndex As Integer, ByVal bLVTopItem As Boolean)
        Try

            With Me
                .btnRedoReplace.Enabled = False
                .btnUndoReplace.Enabled = False

                If .ListViewReplaceResults.Items.Count > 0 Then
                    If ItemIndex > -1 Then
                        If bLVTopItem = True Then
                            .ListViewReplaceResults.TopItem = .ListViewReplaceResults.Items.Item(ItemIndex)
                        End If
                        Dim bIndexEnabled As Boolean = CBool(ItemIndex >= 0)
                        .btnUndoReplace.Enabled = False
                        If CBool(ItemIndex = 0) = True Then
                            .btnGoToFirstReplaceItem.Enabled = False
                            .btnGoToPreviousReplaceItem.Enabled = False
                        Else
                            .btnGoToFirstReplaceItem.Enabled = bIndexEnabled
                            .btnGoToPreviousReplaceItem.Enabled = bIndexEnabled
                        End If
                        .lblCountReplaceItem.Text = ItemIndex + 1 & " von " & .ListViewReplaceResults.Items.Count
                        .lblCountReplaceItem.ForeColor = Color.Blue
                        .btnGoToNextReplaceItem.Enabled = (ItemIndex < .ListViewReplaceResults.Items.Count - 1)
                        .btnGoToLastReplaceItem.Enabled = (ItemIndex < .ListViewReplaceResults.Items.Count - 1)
                        Dim sFindText As String = .ListViewReplaceResults.Items.Item(ItemIndex).Text
                        sFindText = Strings.Left(sFindText, InStr(sFindText, " ") - 1)
                        Dim iStart As Integer = CInt(.ListViewReplaceResults.Items(ItemIndex).SubItems(2).Text)
                        Dim sReplacedText As String = .ListViewReplaceResults.Items(ItemIndex).SubItems(3).Text
                        With Me.RichTextBox1
                            Dim lpSource As String = .Text
                            If Len(lpSource) >= Len(sReplacedText) Then
                                Dim sRevFindText As String = Mid(lpSource, iStart + 1, Len(sFindText))
                                Dim sRevReplacedText As String = Mid(lpSource, iStart + 1, Len(sReplacedText))
                                If CBool(sRevReplacedText = sReplacedText) = True Then
                                    .Select(iStart, Len(sReplacedText))
                                    Dim sSelText As String = .SelectedText
                                    Dim bEnable As Boolean = CBool(sSelText = sReplacedText)
                                    Me.btnUndoReplace.Enabled = bEnable
                                    Me.btnRedoReplace.Enabled = Not bEnable
                                Else
                                    If CBool(sRevFindText = sFindText) = True Then
                                        .Select(iStart, Len(Trim(sFindText)))
                                        Dim sSelText As String = .SelectedText
                                        Dim bEnable As Boolean = CBool(sSelText = sFindText)
                                        Me.btnUndoReplace.Enabled = Not bEnable
                                        Me.btnRedoReplace.Enabled = bEnable
                                    End If
                                End If
                                .Focus()
                            End If
                        End With
                    Else
                        .btnGoToFirstReplaceItem.Enabled = False
                        .btnGoToPreviousReplaceItem.Enabled = False
                        .lblCountReplaceItem.Text = "0 von " & .ListViewReplaceResults.Items.Count
                        .lblCountReplaceItem.ForeColor = Color.Blue
                        .btnGoToNextReplaceItem.Enabled = False
                        .btnGoToLastReplaceItem.Enabled = False
                        .btnUndoReplace.Enabled = False
                        .btnRedoReplace.Enabled = False
                    End If
                Else
                    .btnGoToFirstReplaceItem.Enabled = False
                    .btnGoToPreviousReplaceItem.Enabled = False
                    .lblCountReplaceItem.Text = "0 von 0"
                    .lblCountReplaceItem.ForeColor = Color.Red
                    .btnGoToNextReplaceItem.Enabled = False
                    .btnGoToLastReplaceItem.Enabled = False
                    .btnUndoReplace.Enabled = False
                    .btnRedoReplace.Enabled = False
                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in UpDateReplaceNavigationControls")
        End Try
    End Sub

    Private Sub btnGoToFirstReplaceItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToFirstReplaceItem.Click
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    .Items.Item(0).Selected = True
                    Call UpDateReplaceNavigationControls(0, True)
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToPreviousReplaceItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToPreviousReplaceItem.Click
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    If .Items.Item(0).Selected = True Then
                        Exit Sub
                    Else
                        Dim PrevItem As Integer = 0
                        'Call Freeze()
                        For i As Integer = 0 To .Items.Count - 1
                            If CBool(.Items.Item(i).Selected) = True Then
                                PrevItem = i - 1
                                Exit For
                            End If
                        Next
                        'Call Defrost()
                        .Items.Item(PrevItem).Selected = True
                        Call UpDateReplaceNavigationControls(PrevItem, True)
                    End If
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToNextReplaceItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToNextReplaceItem.Click
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    If .Items.Item(.Items.Count - 1).Selected = True Then
                        Exit Sub
                    Else
                        Dim NextItem As Integer = 0
                        'Call Freeze()
                        For i As Integer = 0 To .Items.Count - 1
                            If CBool(.Items.Item(i).Selected) = True Then
                                NextItem = i + 1
                                Exit For
                            End If
                        Next
                        'Call Defrost()
                        .Items.Item(NextItem).Selected = True
                        Call UpDateReplaceNavigationControls(NextItem, True)
                    End If
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnGoToLastReplaceItem_Click(sender As System.Object, e As System.EventArgs) Handles btnGoToLastReplaceItem.Click
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    .Items.Item(.Items.Count - 1).Selected = True
                    Call UpDateReplaceNavigationControls(.Items.Count - 1, True)
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

#Region "Undo Redo"
    Private Sub btnRedoReplace_Click(sender As Object, e As System.EventArgs) Handles btnRedoReplace.Click
        Try

            With Me.ListViewReplaceResults
                Dim iSelItem As Integer = -1
                Dim iDiv As Integer
                If .Items.Count > 0 Then
                    For i As Integer = 0 To .Items.Count - 1
                        If .Items.Item(i).Selected = True Then
                            iSelItem = i
                            Dim sFindText As String = .Items.Item(i).Text
                            sFindText = Strings.Left(sFindText, InStr(sFindText, " ") - 1)
                            sFindText = Trim(sFindText)
                            Dim iStart As Integer = CInt(.Items(i).SubItems(2).Text)
                            Dim sReplacedText As String = .Items(i).SubItems(3).Text

                            With Me.RichTextBox1
                                Dim lpSource As String = .Text
                                Dim bFind As Boolean = False
                                If Len(lpSource) >= Len(sReplacedText) Or Len(lpSource) >= Len(sFindText) Then
                                    Dim sRevFindText As String = Mid(lpSource, iStart + 1, Len(sFindText))
                                    'auf Übereinstimmung prüfen
                                    If CBool(sRevFindText = sFindText) = True Then 'sFindText wird durch sReplacedText ersetzt
                                        'die vorherige Replace-Aktion wieder herstellen
                                        .Select(iStart, Len(Trim(sFindText)))
                                        .SelectedText = sReplacedText
                                        .Select(iStart, Len(sReplacedText))
                                        iDiv = CInt(Len(sReplacedText) - Len(sFindText))
                                        Me.btnRedoReplace.Enabled = False
                                        Me.btnUndoReplace.Enabled = True
                                    End If
                                End If
                            End With

                            Exit For
                        End If 'Ende von If .Items.Item(i).Selected = True Then
                    Next
                End If
                If iSelItem > -1 Then
                    With Me.ListViewReplaceResults
                        Select Case iSelItem
                            Case .Items.Count - 1
                                'hier müssen keine Startpositionen geändert werden
                            Case Else
                                For i As Integer = iSelItem + 1 To .Items.Count - 1
                                    'die vorhandene Startposition einlesen
                                    Dim iStart As Integer = CInt(.Items(i).SubItems(2).Text)
                                    'die Startposition entsprechend anpassen
                                    .Items(i).SubItems(2).Text = CInt(iStart + iDiv)
                                Next
                        End Select
                    End With
                End If
            End With

        Catch ex As Exception
            Call Defrost()
            MsgBox(ex.Message, MsgBoxStyle.Critical, "Fehler in btnRedoReplace_Click")
        End Try
    End Sub

    Private Sub btnUndoReplace_Click(sender As System.Object, e As System.EventArgs) Handles btnUndoReplace.Click
        Try
            With Me.ListViewReplaceResults
                Dim iSelItem As Integer = -1
                Dim iDiv As Integer
                If .Items.Count > 0 Then
                    For i As Integer = 0 To .Items.Count - 1
                        If .Items.Item(i).Selected = True Then
                            iSelItem = i
                            Dim sFindText As String = .Items.Item(i).Text
                            sFindText = Strings.Left(sFindText, InStr(sFindText, " ") - 1)
                            sFindText = Trim(sFindText)
                            Dim iStart As Integer = CInt(.Items(i).SubItems(2).Text)
                            Dim sReplacedText As String = .Items(i).SubItems(3).Text

                            With Me.RichTextBox1
                                Dim lpSource As String = .Text
                                Dim bFind As Boolean = False
                                If Len(lpSource) >= Len(sReplacedText) Or Len(lpSource) >= Len(sFindText) Then
                                    Dim sRevReplacedText As String = Mid(lpSource, iStart + 1, Len(sReplacedText))
                                    'auf Übereinstimmung prüfen
                                    If CBool(sRevReplacedText = sReplacedText) = True Then 'sReplacedText wird durch sFindText ersetzt
                                        'die vorherige Replace-Aktion rückgängig machen
                                        .Select(iStart, Len(sReplacedText))
                                        .SelectedText = sFindText
                                        .Select(iStart, Len(sFindText))
                                        iDiv = CInt(Len(sFindText) - Len(sReplacedText))
                                        Me.btnUndoReplace.Enabled = False
                                        Me.btnRedoReplace.Enabled = True
                                    End If
                                End If
                            End With

                            Exit For
                        End If 'Ende von If .Items.Item(i).Selected = True Then
                    Next
                    If iSelItem > -1 Then
                        With Me.ListViewReplaceResults
                            Select Case iSelItem
                                Case .Items.Count - 1
                                    'hier müssen keine Startpositionen geändert werden
                                Case Else
                                    For i As Integer = iSelItem + 1 To .Items.Count - 1
                                        'die vorhandene Startposition einlesen
                                        Dim iStart As Integer = CInt(.Items(i).SubItems(2).Text)
                                        'die Startposition entsprechend anpassen
                                        .Items(i).SubItems(2).Text = CInt(iStart + iDiv)
                                    Next
                            End Select
                        End With
                    End If
                End If
            End With
        Catch ex As Exception

        End Try
    End Sub
#End Region

    Private Sub btnRefreshReplaceResults_Click(sender As System.Object, e As System.EventArgs) Handles btnRefreshReplaceResults.Click
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    Dim sSearchText As String = .Items.Item(0).Text
                    sSearchText = Strings.Left(sSearchText, InStr(sSearchText, " gefunden in ...") - 1)
                    Dim sReplaceText As String = .Items(0).SubItems(3).Text
                    With Me
                        Call InsertReplaceTextInListView(.RichTextBox1, sSearchText, sReplaceText, Me.ListViewReplaceResults)
                    End With
                End If
            End With

        Catch ex As Exception

        End Try
    End Sub

    Private Sub btnClearReplaceResults_Click(sender As System.Object, e As System.EventArgs) Handles btnClearReplaceResults.Click
        Try
            With Me
                .ListViewReplaceResults.Items.Clear()
                .btnGoToFirstReplaceItem.Enabled = False
                .btnGoToPreviousReplaceItem.Enabled = False
                .lblCountReplaceItem.Text = "{0} von {0}"
                .btnGoToNextReplaceItem.Enabled = False
                .btnGoToLastReplaceItem.Enabled = False
                .btnUndoReplace.Enabled = False
                .ClsSliderLabel1.Text = String.Empty
            End With
        Catch ex As Exception

        End Try
    End Sub
#End Region

    Private Sub SelectReplaceString()
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    For i As Integer = 0 To .Items.Count - 1
                        If .Items.Item(i).Selected = True Then
                            Dim sFindText As String = .Items.Item(i).Text
                            sFindText = Strings.Left(sFindText, InStr(sFindText, " gefunden in ...") - 1)
                            Dim iStart As Integer = CInt(.Items(i).SubItems(2).Text)
                            Dim sReplacedText As String = .Items(i).SubItems(3).Text
                            With Me.RichTextBox1
                                Dim lpSource As String = .Text
                                Dim sRevFindText As String = Mid(lpSource, iStart + 1, Len(sFindText))
                                Dim sRevReplacedText As String = Mid(lpSource, iStart + 1, Len(sReplacedText))
                                If CBool(sRevReplacedText = sReplacedText) = True Then
                                    .Select(iStart, Len(sReplacedText))
                                    Dim sSelText As String = .SelectedText
                                    Dim bEnable As Boolean = CBool(sSelText = sReplacedText)
                                    Me.btnUndoReplace.Enabled = bEnable
                                    Me.btnRedoReplace.Enabled = Not bEnable
                                Else
                                    If CBool(sRevFindText = sFindText) = True Then
                                        .Select(iStart, Len(Trim(sFindText)))
                                        Dim sSelText As String = .SelectedText
                                        Dim bEnable As Boolean = CBool(sSelText = sFindText)
                                        Me.btnUndoReplace.Enabled = Not bEnable
                                        Me.btnRedoReplace.Enabled = bEnable
                                    End If
                                End If
                                .Focus()
                            End With
                            Exit For
                        End If
                    Next
                End If
            End With

        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in SelectFindString")
        End Try
    End Sub

    Private Sub ListViewReplaceResults_DoubleClick(sender As Object, e As System.EventArgs) Handles ListViewReplaceResults.DoubleClick
        Call SelectReplaceString()
    End Sub

    Private Sub ListViewReplaceResults_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles ListViewReplaceResults.KeyDown
        Try
            If e.KeyCode = Keys.Return Then
                Call SelectReplaceString()
            End If
        Catch ex As Exception

        End Try
    End Sub

    Private Sub ListViewReplaceResults_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles ListViewReplaceResults.SelectedIndexChanged
        Try

            With Me.ListViewReplaceResults
                If .Items.Count > 0 Then
                    Dim SelectedItem As Integer = 0
                    'Call Freeze()
                    For i As Integer = 0 To .Items.Count - 1
                        If CBool(.Items.Item(i).Selected) = True Then
                            SelectedItem = i
                            Exit For
                        End If
                    Next
                    'Call Defrost()
                    Call UpDateReplaceNavigationControls(SelectedItem, False)
                End If
            End With

        Catch ex As Exception
            Call Defrost()
        End Try
    End Sub
#End Region

#End Region

End Class
